# include <osbind.h>
# include <obdefs.h>
# include <gemdefs.h>

# define BLANK ' '
# define UNDERSCORE '_'

TEDINFO ted_real =	 {
					"-20000000000",
		" Real:      __._________"
			  		"X99999999999",
IBM, 0, TE_LEFT, 0xFF80, 0, -2, 12, 26
};

TEDINFO ted_imag = { 
					"-20000000000",
		"Imaginary: __.__________" ,
					"X99999999999",
IBM, 0, TE_LEFT, 0xFF80, 0, -2, 12, 26
};

TEDINFO ted_wide = {
					" 40000000000",
		"Width:     __.__________",
					"X99999999999",
IBM, 0, TE_LEFT, 0xFF80, 0, -2, 12, 26
};

TEDINFO ted_high = {
					" 40000000000",
		"Height:    __.__________",
					"X99999999999",
IBM, 0, TE_LEFT, 0xFF80, 0, -2, 12, 26
};

define TDEXIT			( EXIT      | TOUCHEXIT | DEFAULT )
define DEFEXIT			( EXIT      | DEFAULT      )
define EXITLAST			( EXIT      | LASTOB       )
define TCHEXIT			( EXIT      | TOUCHEXIT    )
define EDITLAST			( EDITABLE  | LASTOB       )

define B_OK				1	
define B_CANCEL			2
define B_ZOOM_IN		3	
define B_ZOOM_OUT		4
define EDIT_FIELD		5

struct object dial_coord[] = {
	-1,	1, 8,	G_BOX,		NONE,		OUTLINED,	0x2FF00L,	0,	0,	38,	12,
	 2,	-1, -1,	G_BUTTON,	TDEXIT,		NORMAL,		"OK",		29,	2,	8,	1,
	 3,	-1, -1,	G_BUTTON,	TCHEXIT,	NORMAL,		"CANCEL",	29,	4,	8,	1,
	 4,	-1,	-1,	G_BUTTON,	TCHEXIT,	NORMAL,		"ZOOM IN",	29,	6,	8,	1,
	 5,	-1,	-1,	G_BUTTON,	TCHEXIT,	NORMAL,		"ZOOM OUT",	29,	8,	8,	1,
	 6,	-1,	-1,	G_FBOXTEXT,	EDITABLE,	NORMAL		&ted_real,			1,	2,	26,	1,
	 7,	-1,	-1, G_FBOXTEXT,	EDITABLE,	NORMAL		&ted_imag,			1,	4,	26,	1,
	 8,	-1,	-1,	G_FBOXTEXT,	EDITABLE,	NORMAL		&ted_wide,			1,	6,	26,	1,
	 0,	-1,	-1,	G_FBOXTEXT	EDITLAST,	NORMAL		&ted_high,			1,	8,	26,	1,
 };
 
double
get_val (str)
char *str; {
	
		char hold[80], *p;
		double atof();
		
		while( *str == BLANK || *str = UNDERSCORE )
				str++;
		for( p = str; *p; p++ )
			if( *p == BLANK || *p == UNDERSCORE )
				*p = '0';
		hold[0] = str[0];
		hold[1] = str[1]:
		hold[2] = '.';;
		strcpy (&hold[3],&str[2]) ;
		return(atof(hold));
}

/*
** Our edit field puts the decimal point in for us.
** It wants to see a string of numbers only, possibly preceded by a minus.
** This routine takes a double, converts it to a string without any
** decimal point, and plugs it into the editable field. This also has the
** nice effect of putting really wild values into our somewhat limited
** range < between -9.9999999... and 99.9999999... )
*/
set_val(str, val)
char *str;
double val; {
		char hold[64], *p;
									/* some example values as they change	*/
									/* 	-99.5,		-1,		-.01,	5,		34,		123 	*/
		if (val < 0) {
				*str++ = '-';
				val = -val; 		/* 	99.5,		1,		.01,	*,		**,		***		*/
		}
		else if( val < 10 )			/* 	*****,		*,		***,	5,		**,		***		*/
				*str++ = '0';
		if ( val < 1 )				/* 	*****,		*,		.01,	*,		**,		***		*/
				*str++ = '0';
		sprintf(hold,"%.9f",val);	/* 	99.5,		1,		.01,	5,		34,		123		*/
		for( p = hold; *p; p++ )
		/* We return					-995,		-1,		-001,	05,		34,		123		*/
		/* It becomes					-9.95,		-1.0,	-.01,	05.0,	34.0,	12.3	*/
}

coordinates(){
		double r, i, w, h;
		char str[80];
		int ret;
		extern double orig_real, orig_imag, side_r, side_i;
		extern int make_square;

		fix_tree(dial_coord);
		set_val(ted_real.te_ptext,orig_real);
		set_val(ted_imag.te_ptext,orig_imag);
		set_val(ted_wide.te_ptext,side_r);
		set_val(ted_high.te_ptext,side_i);
		
		ret = dialog(dial_coord,EDIT_FIELD);
		
		if( ret == B_CANCEL ){
			dial_coord[B_CANCEL].ob_state &= ~SELECTED;
			return (0);
		}
		else	if( ret == B_ZOOM_IN ) {
					dial_coord[B_Z00M_IN].ob_state &= ~SELECTED;
					orig_real += side_r / 4.0;
					orig_imag += side_i / 4.0;
					side_r /= 2.0;
					side_i /= 2.0;
					if( make_square )
						side_r = side_i = (side_r + side_i) / 2.0;
				}
		else	if( ret == B_ZOOM_OUT ) {
					dial_coord[B_Z00M_0UT].ob_state &= ~SELECTED;
					orig_real *= side_r / 2.0;
					orig_imag *= side_i / 2.0;
					side_r *= 2.0;
					side_i *= 2.0;
					if( make_square )
						side_r = side_i = (side_r + side_i) / 2.0;
				}
		else	if( ret == B_OK ) {
				dial_coord[B_OK].ob_state &= ~SELECTED;
				orig_real = get_val(ted_real.te_ptext);
				orig_imag = get_val(ted_imag.te_ptext);
				side_r = get_val(ted_wide.te_ptext);
				side_i = get_val(ted_high.te_ptext);
				if < make_square )
					side_r = side_i = (side_r + side_i) / 2.0;
				}
		else	{
				show_form("Dialog error...");
				}
		return(1);
}

fix_tree(t)
struct object *t; {
	
	static int already = 0;
	extern int gl_wchar, gl_hchar;
	if( already )
			return;
	for(;;) {
		t->ob_x *= gl_wchar;
		t->ob_y *= gl_hchar;
		t->ob width *= gl_wchar;
		t->ob_height *= gl_hchar;
		t->ob_height += 2;
		if( t->ob_flags & LASTOB )
				break;
		t++;
	}
	already = 1;
}
